--------------------------------------------------------------------
--            SymCACP Script Module Random Walk Step Size
-- Symmetrical CA Control Panel   symCACPscript-1
--file for finding the random walk step size of wave on a digonal band
--the average width of the band can be calculated from the universe population
--and the number of cells in the band. This script module records
--the population and population difference over one generation at
--a number of different generations per size and seed

-- check results from a find end run for early band break
-- file FINDEND_RES
-- RULE,GEO,WD,HT,SEED,GEN,PERIOD,POP,TYPE

--------------------------------------------------------------------
--  P. Rendell  19/08/2020
--------------------------------------------------------------------

--
-- output 
-- RULE, WD, HT, SEED, GEO, GEN, RUNLEN


------------------------------------------------------------

local scriptType = "script2-RWstepSize"
local m={}			-- class table
m.cnt = 0
local comProcs			-- common Procedures
local logFile
local g = golly()
local scriptFileData
local gr = require("buildUni") 
local gs = require("search") 
local gsb = require("search-band")
local gsc = require("search-chaos")
m.colonList = {['RULES'] = {"r","R"}, ['SEEDS'] = {"s","R"}, ['GEO'] = {'g',""}}
m.equalList = {['WIDTH0'] = {"d","R"}, ['WIDTH1'] = {"d",""}, ['WIDTHS'] = {"d",""},
               ['LOGFILE'] = {'T',""}, ['RESULTS_OLD'] = {'T',""},
               ['RESULTS_NEW'] = {'T',"R"},  ['FINDEND_RES'] = {'T',"R"},
               ['STEP1WTIMES'] = {"D","R"}, ['STEPWTIMES'] = {"D","R"}, ['COUNT'] = {"D","R"} }

------------------------------------------------------------------------------------------------

--==============================================================================
------------------------------------------------------------------------------------------------

function m.init(lf, cp)
   scriptFileData = {}
   comProcs = cp
   logFile = lf
end

------------------------------------------------------------------------------------------------
function m.buildParmVal(cmd, value, segNo)
   if (scriptFileData[cmd]) then
      comProcs.report.collect("Previous value overwriten "..cmd.." = "..value.."\n",true, segNo)
   end
   scriptFileData[cmd] = value
end

------------------------------------------------------------------------------------------------
function m.buildParmLst(cmd, parms, segNo)
   if (not scriptFileData[cmd]) then
      scriptFileData[cmd] = {}
   end
   for i, parm in pairs(parms) do
      table.insert(scriptFileData[cmd],parm)
   end
end

------------------------------------------------------------------------------------------------
function m.validateScript()
   local valid = true
   if not scriptFileData.HIGHT then
      scriptFileData.HIGHT = scriptFileData.WIDTH
   end
   if not scriptFileData.GEO then
      scriptFileData.GEO = {"R"}
   end
   return valid
end



--==============================================================================
local function makeKey(gen)
   return(m.rule..':'..m.geo..':'..m.wv..':'..m.hv..':'..m.seed..':'..math.floor(gen))
end
--------------------------------------------------------------------------------

local function writeHeader(outFile)
   outFile:write("RULE,GEO,WIDTH,HIGHT,SEED,GENa,POPa,DIFFa,GENb,POPb,DIFFb,GENc,POPc,DIFFc,GENd,POPd,DIFFd,GENe,POPe,DIFFe\n")
   outFile:flush()                                
end
--------------------------------------------------------------------------------

local function writeResultsHead(outFile)
   m.head = string.format("%s,%s,%i,%i,%s", m.rule, m.geo, m.wv, m.hv, m.seed)
   outFile:write(m.head)
end
--------------------------------------------------------------------------------

local function writeResultsTail(outFile)
   if (#m.head > 1) then
      while (m.writtenCnt < 5) do
         outFile:write(",-1,-1,-1")
         m.writtenCnt = m.writtenCnt+1
      end
      outFile:write('\n')
   end
   m.head = ""
   m.writtenCnt = 99
end
--------------------------------------------------------------------------------

local function writeResults(outFile, gen, pop, dif)
   if (m.writtenCnt == 5) then
      outFile:write('\n'..m.head)
      m.writtenCnt = 0
   end
   outFile:write(string.format(",%s,%s,%s", gen, pop, dif))      
   m.writtenCnt = m.writtenCnt + 1
end
--------------------------------------------------------------------------------

function processLine(words)
   local keyBase = words[1]..':'..words[2]..':'..words[3]..':'..words[4]..':'..words[5]..':'  --rule:geo:wd:ht:seed:(gen) = {pop,poDif}
   for rep = 1,5 do
      local ind = 3+rep*3		-- 6,9,12,15,18
      m.linesDone[keyBase..words[ind]] = {words[ind+1],words[ind+2]}	-- pop, popDif
      m.ldcnt=m.ldcnt+1
      logFile:write('#t#processLine  '..keyBase..words[ind]..' '..m.ldcnt..'\n')
   end
end
--------------------------------------------------------------------------------

function loadFindEndData()
   local inFile = io.open ( scriptFileData.FINDEND_RES , "r")
   m.feEnd = {}
   if (inFile) then
      local line = inFile:read("*l")
      while line do
         if (line:sub(1,4) ~= "RULE") then
            words = split(line)
            if #words == 9 then
               m.feEnd[words[1]..':'..words[2]..':'..words[3]..':'..words[4]..':'..words[5]] = tonumber(words[6])
            else
               logFile:write('openOutFile line '..line..' not 9 words\n')
            end                     
         end
         line = inFile:read("*l")
      end 
      logFile:write('FINDEND_RES file read OK\n')
      inFile:close(); inFile = nil
   else
      logFile:write('*** open FINDEND_RES '..scriptFileData.FINDEND_RES..' failed\n')
   end
end
--------------------------------------------------------------------------------

function openOutFile()
   local res = false
   local words = {}
   local key
   local inFile
   local test = true
   m.linesDone = {}
   m.ldcnt = 0
   logFile:write(' openOutFile\n')
   if scriptFileData then
      inFile = io.open ( scriptFileData.RESULTS_NEW , "r")
      if inFile then
         m.outFile = io.open ( scriptFileData.RESULTS_OLD , "w")
         if m.outFile then
            local line = inFile:read("*l")
            while line do
               m.outFile:write(line..'\n')
               line = inFile:read("*l")
            end
            inFile:close(); inFile = nil
            m.outFile:close(); m.outFile = nil
            m.outFile = io.open ( scriptFileData.RESULTS_NEW , "w")
            inFile = io.open ( scriptFileData.RESULTS_OLD , "r")
            if m.outFile and inFile then
               local line = inFile:read("*l")
               logFile:write('m.linesDone started\n')
               while line do
                  if (line:sub(1,4) ~= "RULE") then
                     words = split(line)
                     if #words == 20 then
                        processLine(words)
                     else
                        logFile:write('openOutFile line '..line..' not 20 words\n')
                     end                     
                  end
                  line = inFile:read("*l")
               end 
               logFile:write('m.linesDone collected '..m.ldcnt..'\n')
               res = true
            else
               logFile:write("openOutFile (2nd) files not open infile:"..comProcs.bool2txt(inFile).." outfile:"..comProcs.bool2txt(m.outFile).."\n")
               res = false
               m.outFile:close(); m.outFile = nil
            end
            inFile:close(); inFile = nil
         else
            logFile:write("openOutFile (1st) files not open infile:"..comProcs.bool2txt(inFile).." outfile:"..comProcs.bool2txt(outFile).."\n")
            comProcs.report.collect('no RESULTS_OLD',false)
            inFile:close(); inFile = nil
            res = false
         end         
      else
         logFile:write("openOutFile no old file to copy\n")
         m.outFile = io.open(scriptFileData.RESULTS_NEW, "w")
         res = m.outFile ~= nil
      end
   else
      logFile:write("openOutFile no script file data\n")
      res = false
   end
   if (res) then
      writeHeader(m.outFile)
   end
   return res
end

------------------------------------------------------------

local function divertLog()
   res = true
   local log = io.open ( scriptFileData.LOGFILE , "w")
   if log then
      logFile:write('Diverting to logfile '..scriptFileData.LOGFILE..'\n')
      logDiverted = true
      logFile:close()
      logFile = log
      log = nil
      comProcs.newLog(logFile)
   else
      logFile:write('Failed to divert to logfile '..scriptFileData.LOGFILE..'\n')
      res = false
   end
   return res
end
------------------------------------------------------------

local function reDivertLog()
   if logDiverted then
      logFile:close()
      logFile = comProcs.oldLog()
      logFile:write('Continue after log diversion\n')
   end
   logDiverted = false
end
------------------------------------------------------------

function m.checkDeath()
   local event = g.getevent()
   if (event:find("^key") or event:find("^oclick"))  then
      logFile:write("Fluid stoped by user action\n")
      m.Result = "killed"
   end
   return(m.Result == "killed")
end
------------------------------------------------------------

function m.run(segmentNo)
   logFile:write('\nRWstepSize\n')
   loadFindEndData()
   local test =true
   local logDiverted
   g.show('Random Walk Step Size Started')
   if scriptFileData then
      if scriptFileData.LOGFILE then
         logDiverted = divertLog(scriptFileData.LOGFILE)
      end
      comProcs.LogScript(segmentNo)
      if ( openOutFile() ) then
         local OldOnly = true
         m.GetSamples(OldOnly)
         OldOnly = false
         m.GetSamples(OldOnly)
      end
   else
     comProcs.showTextOV('No Script file Loaded')
   end
   g.show('Finished')
   if (m.outFile ~= nil) then
      m.outFile:close();
      m.outFile = nil
   else
      comProcs.showTextOV('\nProblems copying old data\n')
   end
end
------------------------------------------------------------
------------------------------------------------------------
function collectData(OldOnly)
   local genPlus = scriptFileData.STEPWTIMES*m.wv
   local runGen = scriptFileData.STEP1WTIMES*m.wv - genPlus -1
   local gen = scriptFileData.STEP1WTIMES*m.wv +1
   local maxGen = scriptFileData.STEP1WTIMES * m.wv + 1 + ( scriptFileData.COUNT -1) * (scriptFileData.STEPWTIMES * m.wv + 1)
   local KeyFE = m.rule..':'..m.geo..':'..m.wv..':'..m.hv..':'..m.seed
   if (not m.feEnd[KeyFE]) or (m.feEnd[KeyFE] > maxGen) then
      local built = false
      local header = false
      for i = 1, tonumber(scriptFileData.COUNT) do
         gen = math.floor(scriptFileData.STEP1WTIMES*m.wv + (i - 1) * (scriptFileData.STEPWTIMES*m.wv + 1)) 
         m.checkDeath()
         if (m.Result == 'killed') then break end
         local key = makeKey(gen)
         if ( not (OldOnly or  m.linesDone[key])) then
            if ( not built) then
               gr.doBuild(' SymCACP RWstepSize ', m.wv, m.hv, m.seed, m.geo, m.rule) 
               g.run(runGen)
               g.update()
               built = true
               if ( not header) then 
                  writeResultsHead(m.outFile)
                  header = true
               end
            end
            g.run(genPlus)
            local pop = tonumber(g.getpop())
            g.run(1)
            runGen = 0
            local thisPop = tonumber(g.getpop())
            local dif = math.abs(pop - thisPop)
            writeResults(m.outFile, gen, thisPop, dif)
            g.update()
            logFile:write('#t# res gen '..gen..' g.getgen '..g.getgen()..' key '..key..'\n')
         elseif(OldOnly and  m.linesDone[key] ) then
            if ( not header) then 
               writeResultsHead(m.outFile)
               header = true
            end
            writeResults(m.outFile,  gen, m.linesDone[key][1],  m.linesDone[key][2])
            logFile:write('#t# linesDone '..key..' '..'\n')
         end
         runGen = runGen + genPlus +1
      end
      if (header) then
         writeResultsTail(m.outFile)	-- tidy up last line of output
      end
   else
      logFile:write('*** Line Removed '..KeyFE..' '..'\n')
   end
   return(m.Result)
end
--------------------------------------------------------------------------

function m.GetSamples(OldOnly)   
   m.Result = ''
   m.head = ''
   m.writtenCnt = 0
   for wv = scriptFileData.WIDTH0,scriptFileData.WIDTH1,scriptFileData.WIDTHS do
      m.wv = wv
      m.hv = wv
      for ir = 1,#scriptFileData.RULES do
         m.rule = scriptFileData.RULES[ir]
         for geoI,geo in pairs(scriptFileData.GEO) do
            m.geo = geo
            g.show("width "..scriptFileData.WIDTH0..","..scriptFileData.WIDTH1..","..scriptFileData.WIDTHS)
            for is = 1,#scriptFileData.SEEDS do
               if ( not OldOnly) then
                  g.new('SymCACP Script '..scriptFileData.RESULTS_NEW..' '..m.rule..' ')
               end
               m.seed = scriptFileData.SEEDS[is]
               m.Result = collectData(OldOnly)
            end
            m.outFile:flush()
            if m.Result == 'killed' then break end
         end
         if m.Result == 'killed' then break end
      end
      if m.Result == 'killed' then break end
   end
   if ((not OldOnly) and logDiverted) then
      logFile:flush()
      reDivertLog()
   end
end
return m
------------------------------------------------------------
